#include <SoftwareSerial.h>             // Load the function library of SoftwareSerial.
SoftwareSerial mySerial(9,8);           // Definition mySerial pin (RX, TX) [RX=D9 pin; TX=D8 pin]
#include <Bounce.h>                   // Load the function library of switch.
Bounce Vin = Bounce(3, 10);           // Define "Vin" as D3 pin, and the mechanical trigger will not be recorded within 10ms.
int Vout, Vout4, sensorPin = A0;        // Define Vout、Vout4、SensorPin as int.
double sensorValue, Vtemp, Rtemp, TECtemp;    // Define sensorValue、Vtemp、Rtemp、TECtemp as double.
#define TECPin  5           //the number(D5) of the TEC pin
boolean bSwitch;              // Define bSwitch as booleam.
int X, Y;               // Define X、Y as int.

void setup(){
    pinMode (2,OUTPUT);         //set the digital pin 2 as output.
    pinMode (4,OUTPUT);         //set the digital pin 4 as output.
    pinMode (3,INPUT);          //set the digital pin 3 as input.
    pinMode (A5,OUTPUT);        //set the A5 pin as output.
    digitalWrite(A5,LOW);
    Vout = LOW;
    Vout4 = LOW;
    pinMode(TECPin , OUTPUT);       //set the TECPin as output.
    analogWrite(TECPin, 0);         // TEC turn off.
    Serial.begin(115200);         //Initialize serial and wait for port to open.
    mySerial.begin(57600);          //Initialize myserial and wait for port to open.
    bSwitch=false; 
}
void loop(){    
    sensorValue = 0;
    for (int i=0; i<10; i++) {
         sensorValue += analogRead(sensorPin);  // read the value from the sensor
    }
    sensorValue = sensorValue/10;
     /* TECtemp value is calculated from sensorValue. */
    Vtemp = ( (double) sensorValue*5)/(1024);
    Rtemp = (120 * (double) Vtemp)/(5 - (double) Vtemp);
    if (Rtemp == 963)    {  TECtemp = -55;   }
    else if (Rtemp > 670.1)   {   TECtemp = 1/(log(Rtemp/963)/3529.9+1/218.13)-273.13;       }
    else if (Rtemp > 471.7)   {   TECtemp = 1/(log(Rtemp/670.1)/3574.22+1/223.13)-273.13;    }
    else if (Rtemp > 336.5)   {   TECtemp = 1/(log(Rtemp/471.7)/3592.52+1/228.13)-273.13;    }
    else if (Rtemp > 242.6)   {   TECtemp = 1/(log(Rtemp/336.5)/3632.74+1/233.13)-273.13;    }
    else if (Rtemp > 177)     {   TECtemp = 1/(log(Rtemp/242.6)/3650.54+1/238.13)-273.13;    }
    else if (Rtemp > 130.4)   {   TECtemp = 1/(log(Rtemp/177)/3686.55+1/243.13)-273.13;      }
    else if (Rtemp > 97.07)   {   TECtemp = 1/(log(Rtemp/130.4)/3707.93+1/248.13)-273.13;    }
    else if (Rtemp > 72.93)   {   TECtemp = 1/(log(Rtemp/97.07)/3736.59+1/253.13)-273.13;    }
    else if (Rtemp > 55.33)   {   TECtemp = 1/(log(Rtemp/72.93)/3751.79+1/258.13)-273.13;    }
    else if (Rtemp > 42.32 )  {   TECtemp = 1/(log(Rtemp/55.33)/3782.42+1/263.13)-273.13;    }
    else if (Rtemp > 32.65)   {   TECtemp = 1/(log(Rtemp/42.32)/3799.62+1/268.13)-273.13;    }
    else if (Rtemp > 25.39)   {   TECtemp = 1/(log(Rtemp/32.65)/3820.91+1/273.13)-273.13;    }
    else if (Rtemp > 19.9)    {   TECtemp = 1/(log(Rtemp/25.39)/3837.11+1/278.13)-273.13;    }
    else if (Rtemp > 15.71)   {   TECtemp = 1/(log(Rtemp/19.9)/3857.38+1/283.13)-273.13;     }
    else if (Rtemp > 12.49)   {   TECtemp = 1/(log(Rtemp/15.71)/3874.48+1/288.13)-273.13;    }
    else if (Rtemp > 10)      {   TECtemp = 1/(log(Rtemp/12.49)/3886.15+1/293.13)-273.13;    }
    else if (Rtemp > 8.057)   {   TECtemp = 1/(log(Rtemp/10)/3904.87+1/298.13)-273.13;       }
    else if (Rtemp > 6.53)    {   TECtemp = 1/(log(Rtemp/8.057)/3922.59+1/303.13)-273.13;    }
    else if (Rtemp > 5.327)   {   TECtemp = 1/(log(Rtemp/6.531)/3932.17+1/308.13)-273.13;    }
    else if (Rtemp > 4.369)   {    TECtemp = 1/(log(Rtemp/5.327)/3949.86+1/313.13)-273.13;   }
    else if (Rtemp > 3.603)   {    TECtemp = 1/(log(Rtemp/4.369)/3963.19+1/318.13)-273.13;   }
    else if (Rtemp > 2.986)   {    TECtemp = 1/(log(Rtemp/3.603)/3983.12+1/323.13)-273.13;   }
    else if (Rtemp > 2.488)   {    TECtemp = 1/(log(Rtemp/2.986)/3988.84+1/328.13)-273.13;   }
    else if (Rtemp > 2.083)   {    TECtemp = 1/(log(Rtemp/2.488)/4002.59+1/333.13)-273.13;   }
    else if (Rtemp > 1.752)   {    TECtemp = 1/(log(Rtemp/2.083)/4015.57+1/338.13)-273.13;   }
    else if (Rtemp > 1.481)   {    TECtemp = 1/(log(Rtemp/1.752)/4014.62+1/343.13)-273.13;   }
    else if (Rtemp > 1.258)   {    TECtemp = 1/(log(Rtemp/1.481)/4012.46+1/348.13)-273.13;   }
    else if (Rtemp > 1.072)   {    TECtemp = 1/(log(Rtemp/1.258)/4046.85+1/353.13)-273.13;   }
    else if (Rtemp > 0.9177)  {    TECtemp = 1/(log(Rtemp/1.072)/4042.16+1/358.13)-273.13;   }
    else if (Rtemp > 0.7885)  {    TECtemp = 1/(log(Rtemp/0.9177)/4056.84+1/363.13)-273.13;  }
    else if (Rtemp > 0.7885)  {    TECtemp = 1/(log(Rtemp/0.9177)/4056.84+1/363.13)-273.13;  }
    else if (Rtemp > 0.68)    {    TECtemp = 1/(log(Rtemp/0.7885)/4066.95+1/368.13)-273.13;  }
    else if (Rtemp > 0.5886)  {    TECtemp = 1/(log(Rtemp/0.68)/4073.20+1/373.13)-273.13;    }
    else if (Rtemp > 0.5112)  {    TECtemp = 1/(log(Rtemp/0.5886)/4085.01+1/378.13)-273.13;  }
    else if (Rtemp > 0.4454)  {    TECtemp = 1/(log(Rtemp/0.5112)/4097.94+1/383.13)-273.13;  }
    else if (Rtemp > 0.3893)  {    TECtemp = 1/(log(Rtemp/0.4454)/4108.29+1/388.13)-273.13;  }
    else if (Rtemp > 0.3417)  {    TECtemp = 1/(log(Rtemp/0.3893)/4082.49+1/393.13)-273.13;  }
    else if (Rtemp > 0.3009)  {    TECtemp = 1/(log(Rtemp/0.3417)/4081.63+1/398.13)-273.13;  }
    else if (Rtemp > 0.2654)  {    TECtemp = 1/(log(Rtemp/0.3009)/4131+1/403.13)-273.13;     }
    else if (Rtemp > 0.2348)  {    TECtemp = 1/(log(Rtemp/0.2654)/4131.1+1/408.13)-273.13;   }
    else if (Rtemp == 0.2348) {    TECtemp = 140;  }
    /*
       < 22,   22~25,   25~28,   28~30,   30~32,   32~34,   34~37,    >37
       0%      20%      30%      40%      50%      70%      80%       100%
     */
    if (TECtemp < 22)                      {  analogWrite(TECPin, 0);   }
    else if (TECtemp >= 22 && TECtemp < 25) {  analogWrite(TECPin, 50);   }
    else if (TECtemp >= 25 && TECtemp < 28) {  analogWrite(TECPin, 75);   }
    else if (TECtemp >= 28 && TECtemp < 30) {  analogWrite(TECPin, 101);  }
    else if (TECtemp >= 30 && TECtemp < 32) {  analogWrite(TECPin, 127);  }
    else if (TECtemp >= 32 && TECtemp < 34) {  analogWrite(TECPin, 175);  }
    else if (TECtemp >= 34 && TECtemp < 37) {  analogWrite(TECPin, 200);  }
    else if (TECtemp >= 37)                 {  analogWrite(TECPin, 255);  }
    
    if (TECtemp >= 35) {    // When temperature value is over 35℃, the LED light of PIM A5 pin illuminate.
        digitalWrite(A5, HIGH);                          
    }
    else {          // When temperature value is less than 35℃, the LED light of PIM A5 pin turn off.
        digitalWrite(A5, LOW);                             
    }  

    if (Vin.update() == true && Vin.read() == HIGH) {
        if (Vout == HIGH) {         // Laser turn off.
           Vout = LOW;
           Vout4 = LOW;
           digitalWrite(2, Vout);
           digitalWrite(4, Vout4);
           bSwitch=false;
        }
        else {              // Laser turn on.
           if (TECtemp < 35) {          // When TECtemp < 35,
               delay(3000);           // wait 3sec Laser turn on.
               Vout = HIGH; 
               Vout4 = HIGH;
               digitalWrite(2, Vout);
               delay(40);
               digitalWrite(4, Vout4); 
               delay(10);
               delay(2000);
               bSwitch=true; 
           }               
           else {               // When TECtemp >=35,
               Vout = LOW;            // Laser turn on.
               Vout4 = LOW;
               digitalWrite(2, Vout);
               digitalWrite(4, Vout4);
               bSwitch=false;
           }
        }
    }
    if (bSwitch==true) {            //When Laser on,
        if (!mySerial.available()) {            // Laser turn off when data is not be received.
            digitalWrite(2,LOW);                                 
            digitalWrite(4,LOW);
            Vout = LOW;
            Vout4 = LOW;
            bSwitch = false;
            Serial.println("No data, Laser OFF!");
        }   
        else {                  // When data is be received,
            if (TECtemp >= 40)                        // TECtemp >= 40，
            {                       // Laser turn off.
                 Vout = LOW;
                 Vout4 = LOW;
                 digitalWrite(2, Vout);
                 digitalWrite(4, Vout4);
                 bSwitch=false; 
            } 
             else {                 // TECtemp < 40，
                  char buffer[2];
                     mySerial.readBytes (buffer, 2);
                     X = buffer[0];
                     Y = buffer[1];
                     if ((X == 10) && (Y != 20)) {          // X =10 and Y ≠20,
                         Vout = LOW;                        // Laser turn off.
                         Vout4 = LOW;
                         digitalWrite(2, Vout);
                         digitalWrite(4, Vout4);
                         bSwitch=false;
                         Serial.println("Data Err. !");
                         Serial.print("X = ");
                         Serial.println(X);
                         Serial.print("Y = ");
                         Serial.println(Y);   
                     }
                     if ((X == 20) && (Y != 10)) {          // X =20 and Y ≠10,
                         Vout = LOW;                        // Laser turn off.
                         Vout4 = LOW;
                         digitalWrite(2, Vout);
                         digitalWrite(4, Vout4);
                         bSwitch=false;
                         Serial.println("Data Err. !");
                         Serial.print("X = ");
                         Serial.println(X);
                         Serial.print("Y = ");
                         Serial.println(Y);   
                     }
             }
        }
        mySerial.flush();
    }
    delay (50);
}

